/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.sponge.listeners;

import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shared.listeners.LoginProfileEvent;
import net.skinsrestorer.shared.listeners.LoginProfileListener;
import net.skinsrestorer.sponge.SkinsRestorer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.profile.GameProfile;

public class LoginListener
extends LoginProfileListener
implements EventListener<ClientConnectionEvent.Auth> {
    private final SkinsRestorer plugin;

    public void handle(@NotNull ClientConnectionEvent.Auth event) {
        LoginProfileEvent wrapped = this.wrap(event);
        if (this.handleSync(wrapped)) {
            return;
        }
        GameProfile profile = event.getProfile();
        profile.getName().flatMap(name -> this.handleAsync(wrapped)).ifPresent(skin -> {
            try {
                this.plugin.getSkinApplierSponge().updateProfileSkin(profile, (String)skin);
            }
            catch (SkinRequestException e) {
                this.plugin.getSrLogger().debug(e);
            }
        });
    }

    private LoginProfileEvent wrap(final ClientConnectionEvent.Auth event) {
        return new LoginProfileEvent(){

            @Override
            public boolean isOnline() {
                return Sponge.getServer().getOnlineMode();
            }

            @Override
            public String getPlayerName() {
                return (String)event.getProfile().getName().orElseThrow(() -> new RuntimeException("Could not get player name!"));
            }

            @Override
            public boolean isCancelled() {
                return event.isCancelled();
            }
        };
    }

    public LoginListener(SkinsRestorer plugin) {
        this.plugin = plugin;
    }

    @Override
    public SkinsRestorer getPlugin() {
        return this.plugin;
    }
}

